<?php
session_start();

// --- 1. CONFIGURACIÓN DE BASE DE DATOS ---
$servername = "localhost";
$username = "root";   
$password = "";       
$dbname = "mi_empresa_db"; 

// Crear conexión (COMENTADA PARA MODO LOCAL/DEMO)
// $conn = new mysqli($servername, $username, $password, $dbname);

// Verificar conexión
/*
if ($conn->connect_error) {
    die("Conexión fallida: " . $conn->connect_error);
}
*/

// --- 2. CONFIGURACIÓN DE CARGA DE IMÁGENES ---
$target_dir = "uploads/eventos/"; 
if (!file_exists($target_dir)) {
    mkdir($target_dir, 0777, true);
}

// Inicializar repositorio local si no existe (Seguridad para panel_process)
if (!isset($_SESSION['eventos'])) {
    $_SESSION['eventos'] = [];
}

// Verificar si se envió el formulario
if ($_SERVER["REQUEST_METHOD"] == "POST") {

    // Recoger y sanitizar datos básicos
    $action = $_POST['action'];
    $titulo = $_POST['titulo'] ?? ''; 
    $descripcion = $_POST['descripcion'] ?? '';
    $fecha = $_POST['fecha'] ?? '';
    $hora = $_POST['hora'] ?? '';
    $categoria = $_POST['categoria'] ?? '';
    $precio = !empty($_POST['precio']) ? $_POST['precio'] : 0.00;
    
    // Checkbox: si está marcado envía 'activo', sino 'inactivo'
    $estado = isset($_POST['estado']) ? 'activo' : 'inactivo';

    // Manejo de la Imagen
    $imagen_path = ""; 
    $uploadOk = 1;
    
    if (isset($_FILES["imagen"]) && $_FILES["imagen"]["size"] > 0) {
        $fileName = basename($_FILES["imagen"]["name"]);
        $target_file = $target_dir . "evento_" . time() . "_" . $fileName;
        $imageFileType = strtolower(pathinfo($target_file, PATHINFO_EXTENSION));

        $check = getimagesize($_FILES["imagen"]["tmp_name"]);
        if($check === false) { $uploadOk = 0; } 
        if($imageFileType != "jpg" && $imageFileType != "png" && $imageFileType != "jpeg") { $uploadOk = 0; } 

        if ($uploadOk == 1) {
            if (move_uploaded_file($_FILES["imagen"]["tmp_name"], $target_file)) {
                $imagen_path = $target_file; 
            }
        }
    }

    // --- 3. LÓGICA DE ACCIONES (LOCAL CON SESSIONS) ---

    // ==========================================
    // CREAR NUEVO EVENTO
    // ==========================================
    if ($action == "create") {
        
        // Generar ID local (buscar el ID más alto y sumar 1)
        $new_id = 1;
        if (!empty($_SESSION['eventos'])) {
            $ids = array_column($_SESSION['eventos'], 'id');
            $new_id = max($ids) + 1;
        }

        $nuevo_evento = [
            'id' => $new_id,
            'titulo' => $titulo,
            'descripcion' => $descripcion,
            'fecha' => $fecha,
            'hora' => $hora,
            'precio' => $precio,
            'categoria' => $categoria,
            'estado' => $estado,
            'imagen' => $imagen_path // Si está vacío, se queda vacío
        ];

        // Guardar en sesión
        $_SESSION['eventos'][] = $nuevo_evento;

        /* CÓDIGO SQL ORIGINAL (Para cuando conectes BD)
        $sql = "INSERT INTO eventos (titulo, descripcion, fecha, hora, precio, categoria, estado, imagen) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("ssssdsss", $titulo, $descripcion, $fecha, $hora, $precio, $categoria, $estado, $imagen_path);
        $stmt->execute();
        */
        
        header("Location: panel.php?status=success");
    }

    // ==========================================
    // ACTUALIZAR EVENTO EXISTENTE
    // ==========================================
    elseif ($action == "update") {
        $id = $_POST['event_id'];
        
        // Buscar y actualizar en el array de sesión
        foreach ($_SESSION['eventos'] as &$evento) {
            if ($evento['id'] == $id) {
                $evento['titulo'] = $titulo;
                $evento['descripcion'] = $descripcion;
                $evento['fecha'] = $fecha;
                $evento['hora'] = $hora;
                $evento['precio'] = $precio;
                $evento['categoria'] = $categoria;
                $evento['estado'] = $estado;
                
                // Solo actualizar imagen si se subió una nueva
                if (!empty($imagen_path)) {
                    $evento['imagen'] = $imagen_path;
                }
                break; // Terminamos al encontrarlo
            }
        }
        // Desvincular referencia del último elemento
        unset($evento);

        /* CÓDIGO SQL ORIGINAL
        if ($uploadOk == 1 && !empty($imagen_path)) {
             $sql = "UPDATE eventos SET titulo=?, descripcion=?, fecha=?, hora=?, precio=?, categoria=?, estado=?, imagen=? WHERE id=?";
        } else {
             $sql = "UPDATE eventos SET titulo=?, descripcion=?, fecha=?, hora=?, precio=?, categoria=?, estado=? WHERE id=?";
        }
        */

        header("Location: panel.php?status=success");
    }

    // ==========================================
    // ELIMINAR EVENTO
    // ==========================================
    elseif ($action == "delete") {
        $id = $_POST['event_id'];
        
        // Filtrar el array para quitar el ID seleccionado
        $_SESSION['eventos'] = array_filter($_SESSION['eventos'], function($evt) use ($id) {
            return $evt['id'] != $id;
        });

        /* CÓDIGO SQL ORIGINAL
        $sql = "DELETE FROM eventos WHERE id=?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("i", $id);
        $stmt->execute();
        */

        header("Location: panel.php?status=success");
    }

} else {
    header("Location: panel.php");
}
?>